//LINK updates 

function addNoOpener(link) {
  let linkTypes = (link.getAttribute('rel') || '').split(' ');
  if (!linkTypes.includes('noopener')) {
    linkTypes.push('noopener noreferrer');
  }
  link.setAttribute('rel', linkTypes.join(' ').trim());
}

function addNewTabMessage(link) {
  if (!link.querySelector('.visually-hidden')) {
    link.insertAdjacentHTML('beforeend', '<span class="visually-hidden">(opens in a new tab)</span>');
  }
}

document.querySelectorAll('a[target="_blank"]').forEach(link => {
  addNoOpener(link);
  addNewTabMessage(link);
});


// POPOVER 

// Select all elements with the data-bs-toggle="popover" attribute
var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'));

// Initialize popovers with custom options
var popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
  return new bootstrap.Popover(popoverTriggerEl, {
    trigger: 'manual' // Use manual trigger to control show/hide behavior
  });
});

// Function to toggle popover visibility
popoverTriggerList.forEach(function (popoverTriggerEl, index) {
  popoverTriggerEl.addEventListener('click', function () {
    var popover = popoverList[index];
    if (popover._isShown()) {
      popover.hide();
    } else {
      popover.show();
    }
  });
});

// Hide popover when clicking outside of it
document.addEventListener('click', function (event) {
  popoverTriggerList.forEach(function (popoverTriggerEl, index) {
    var popover = popoverList[index];
    if (!popoverTriggerEl.contains(event.target) && !popover.tip.contains(event.target)) {
      popover.hide();
    }
  });
});

