function addNoOpener(link) {
  let linkTypes = (link.getAttribute('rel') || '').split(' ');
  if (!linkTypes.includes('noopener')) {
    linkTypes.push('noopener noreferrer');
  }
  link.setAttribute('rel', linkTypes.join(' ').trim());
}

function addNewTabMessage(link) {
  if (!link.querySelector('.visually-hidden')) {
    link.insertAdjacentHTML('beforeend', '<span class="visually-hidden">(opens in a new tab)</span>');
  }
}

document.querySelectorAll('a[target="_blank"]').forEach(link => {
  addNoOpener(link);
  addNewTabMessage(link);
});